require( "scripts/chocshopstyle.lua" )

HeaderFont = {
  edwardian_medium,
  31,
  WhiteColor
};

TableInfoFont = {
  edwardian_medium,
  30,
 WhiteColor
};

ErrorFont = {
  edwardian_medium,
  24,
 WhiteColor
};

AccountFont = {
  edwardian_medium,
  21,
  WhiteColor
};

AccountTextEditFont = {
	edwardian_medium,
	16,
	BlackColor
};

ScoreFont = {
  edwardian_medium,
  14,
  WhiteColor
};

HiscoreSubmitLegal = {
  edwardian_medium,
  14,
  WhiteColor
};

CheckboxTextFont = {
	edwardian_medium,
	15,
	WhiteColor
};

kPlayerNameY = 110;
kScoreY = 150;
kYourPFAccountY = 205;
kAccountNameY = 225;
kPasswordY = 260;
kRememberY = 300;

kPrivacyLabel = 'scores_privacy';
if (IsEnabled(kHiscoreAnonymous)) then
	kPrivacyLabel = 'scores_privacy_info';
end


function SwitchModes( submit )
	
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	if submit then
		DebugOut( "SwitchModes true "..tostring(localHS).." "..tostring(anonHS));
	else
		DebugOut( "SwitchModes false "..tostring(localHS).." "..tostring(anonHS));
	end

	EnableWindow("header",not submit);
	EnableWindow("headershadow",not submit);
	EnableWindow("playertext", not submit);
	EnableWindow("yourscore", not submit);
	EnableWindow("eligiblescore", not submit);
	EnableWindow("yourpfaccount", not submit and fullHS);
	EnableWindow("nametext", not submit and fullHS);
	EnableWindow("passtext", not submit and fullHS);

	EnableWindow("nameeditbox", not submit );
	EnableWindow("accounteditbox", not submit and fullHS);
	EnableWindow("passeditbox", not submit and fullHS);
	EnableWindow("remember", not submit and fullHS);

	EnableWindow("submittoserver", not submit);
	EnableWindow("submitcancel", not submit);
	EnableWindow("submitconnect", submit);
	
	EnableWindow("privacybutton", not submit);
	EnableWindow("legal_text", not submit);

end

MakeDialog
{
	name = "hiscoresubmitscreen",
	
	RBounceWindow 
	{
	    x			= 175, 
	    y			= -1500,
	    w			= 450,
	    h			= 500,
	    targetposx	= 175, 
	    targetposy	= 50,
	    bouncelen	= 300, 
	    bouncefunc	= "sincx",
	    
		KSplit9Image
		{ 
			x		= kCenter,
			y		= kCenter,
			w		= 450,
			h		= 500,
			x1		= 40,
			y1		= 40,
			x2		= 40,
			y2		= 40,
			image	= "ui/backgrounds/split9_dialog",

			---------------------------------------------- Header
			Text
			{
				x		= 0,
				y		= 37,
				w		= kMax,
				h		= 50,
				font	= HeaderFont,
				name	= "header",
				flags	= kHAlignCenter + kVAlignTop,
				label	= "#<outline color='000000' size='2'>"..GetString( "scores_submitglobalhs" ).."</outline>"
			},
			
			---------------------------------------------- Status Messages
			Text
			{
				x		= 30,
				y		= 0,
				w		= kMax - 30,
				h		= kMax,
				font	= TableInfoFont,
				name	= "submitconnect",
				flags	= kHAlignCenter + kVAlignCenter,
				label	= "scores_connecting"
			},
			
			Text
			{
				x		= 30,
				y		= 0,
				w		= kMax - 30,
				h		= kMax,
				font	= ErrorFont,
				name	= "submiterror",
				flags	= kHAlignCenter + kVAlignCenter,
				label	= "#Error Message"
			},

			---------------------------------------------- Player Name
			Text
			{
				x		= 0,
				y		= kPlayerNameY + 5,
				w		= 115,--145,
				h		= kMax,
				font	= AccountFont,
				name	= "playertext",
				flags	= kHAlignRight + kVAlignTop,
				label	= "scores_playerlabel"
			},
			
			KSplit9Image
			{
			    x1      = 1,
			    y1      = 1,
			    x2      = 1,
			    y2      = 1,
			    w       = 300,
			    h       = 32,
				x		= 120,--155,
				y		= kPlayerNameY,
				name	= "nameeditbox",
				image	= "gfx/textfield",
				
				TextEdit
				{
					x		= 3,
					y		= 7,
					w		= kMax,
					h		= kMax,
					font	= AccountTextEditFont,
					name	= "nameedit",
					label	= gNameEdit,
					length	= 20,
					ignore	= kIllegalNameChars
				},
			},
			
			---------------------------------------------- Player Score
			Text
			{
				x		= 0,
				y		= kScoreY,
				w		= 115,--145,
				h		= kMax,
				font	= AccountFont,
				name	= "yourscore",
				flags	= kHAlignRight + kVAlignTop,
				label	= "scores_scorelabel"
			},
			
			Text
			{
				x		= 125,--155,
				y		= kScoreY,
				w		= 100,
				h		= kMax,
				font	= AccountFont,
				name	= "eligiblescore",
				flags	= kHAlignLeft + kVAlignTop,
				label	= "12345"
			},
			
			---------------------------------------------- Your PF Account
			Text
			{
				x		= 125,--155,
				y		= kYourPFAccountY,
				w		= 150,
				h		= kMax,
				font	= ScoreFont,
				name	= "yourpfaccount",
				flags	= kHAlignLeft + kVAlignTop,
				label	= "scores_pfaccount"
			},
			
			---------------------------------------------- PF Account Username
			Text
			{
				x		= 0,
				y		= kAccountNameY + 5,
				w		= 115,--145,
				h		= kMax,
				font	= AccountFont,
				name	= "nametext",
				flags	= kHAlignRight + kVAlignTop,
				label	= "scores_namelabel"
			},
			
			KSplit9Image
			{
			    x1      = 1,
			    y1      = 1,
			    x2      = 1,
			    y2      = 1,
			    w       = 300,
			    h       = 32,
				x		= 120,--155,
				y		= kAccountNameY,
				name	= "accounteditbox",
				image	= "gfx/textfield",
				
				TextEdit
				{
					x		= 3,
					y		= 7,
					w		= kMax,
					h		= kMax,
					font	= AccountTextEditFont,
					name	= "accountedit",
					label	= gAccountEdit,
					length	= 26,
					ignore	= kIllegalNameChars
				},
			},
			
			---------------------------------------------- PF Account Password
			Text
			{
				x		= 0,
				y		= kPasswordY + 5,
				w		= 115,--145,
				h		= kMax,
				font	= AccountFont,
				name	= "passtext",
				flags	= kHAlignRight + kVAlignTop,
				label	= "scores_passwordlabel"
			},
			
			KSplit9Image
			{
			    x1      = 1,
			    y1      = 1,
			    x2      = 1,
			    y2      = 1,
			    w       = 300,
			    h       = 32,
				x		= 120,--155,
				y		= kPasswordY,
				name	= "passeditbox",
				image	= "gfx/textfield",
				
				TextEdit
				{
					x			= 3, 
					y			= 7, 
					w			= kMax, 
					h			= kMax,
					font		= AccountTextEditFont,
					name		= "passedit",
					label		= gPassEdit,
					password	= true,
					length		= 26
				},
			},
			
			---------------------------------------------- Remember Account
			SetStyle( CSCheckBoxCircleStyle ),
			Button
			{
				x			= 122, 
				y			= kRememberY,
				name		= "remember",
				type		= kToggle,
				w			= 260,
				--scale		= 0.5,
				rollover	= "",
				drop		= false,
				sound		= "audio/sfx/buttonclick",
				Text
				{
					x		= 35,
					y		= 8,
					w		= 250,
					h		= 25,
					font	= CheckboxTextFont,
					name	= "rememberlabel",
					flags	= kHAlignLeft + kVAlignTop,
					label	= "scores_remember",
				},
			},
			
			---------------------------------------------- Legal Text
			Text
			{
			    name    = "legal_text",
				x		= 30,
				y		= 365,
				w		= kMax - 30,
				h		= 50,
				font	= HiscoreSubmitLegal,
				flags	= kHAlignLeft + kVAlignTop,
				label	= kPrivacyLabel
			},
			
			---------------------------------------------- Submit
			SetStyle(CSOvalGreenButtonStyle);
			Button
			{
				x			= 60,
				y			= 405,
				font		= ChoosePlayer_ButtonFont,
				name		= "submittoserver",
				label		= "scores_submit",
				type		= kPush,
				command		= 
					function()
						name = GetLabel( "nameedit" );
						account = GetLabel( "accountedit" );
						pass = GetLabel( "passedit" );
						remember = GetButtonToggleState( "remember" );
						SubmitToServer( name, account, pass, remember );
					end
			},
			
			---------------------------------------------- Cancel
			SetStyle(CSOvalRedButtonStyle);
			Button
			{
				x			= 275,
				y			= 405,
				font		= ChoosePlayer_ButtonFont,
				name		= "submitcancel",
				label		= "app_cancel",
				type		= kPush,
				command		= 
					function()
					    DoTransition( kBounceBack );
					    PopModal( 'hiscoresubmitscreen' );
					end
			},
		
			---------------------------------------------- Error Ok
			SetStyle(CSOvalGreenButtonStyle);
			Button
			{
				x			= 275,
				y			= 405,
				font		= ChoosePlayer_ButtonFont,
				name		= "submiterrorok",
				label		= "app_ok",
				type		= kPush,
				command		= 
					function()
						EnableWindow( "submiterrorok", false );
						EnableWindow( "submiterror", false );
						SwitchModes( false );
					end
			},
			
			---------------------------------------------- Privacy Policy
			Button
			{
				x			= 0,
				y			= 0,
				w			= 0,
				h			= 0,
				graphics	= {},
				name		= "privacybutton",
				command		= 
					function()
						if ( IsEnabled(kHiscoreAnonymous) ) then
							DisplayDialog { "scripts/ok.lua", body ="scores_privacy_anon", title = "" };
						else
							LaunchPrivacyPolicy();
						end
					end
			},
		},
	},
}

EnableWindow( "submitconnect", false );
EnableWindow( "submiterror", false );
EnableWindow( "submiterrorok", false );
SetButtonToggleState( 'remember', gRemember );
SetFocus( "nameedit" );
InitUserScore();